﻿CREATE OR REPLACE FUNCTION createTable() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	msgFinal text := 'FOI CRIADA';
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM information_schema.columns 
						WHERE table_name= 'pdv_cupom_nao_fiscal_est_rps') THEN 

		CREATE TABLE public.pdv_cupom_nao_fiscal_est_rps
		(
		  cd_emp numeric(6,0) NOT NULL DEFAULT 0,
		  cd_filial numeric(6,0) NOT NULL DEFAULT 0,
		  cd_cx numeric(6,0) NOT NULL DEFAULT 0,
		  cd_ctr numeric(6,0) NOT NULL DEFAULT 0,
		  CONSTRAINT pdv_cupom_nao_fiscal_est_rps_pkey PRIMARY KEY (cd_emp, cd_filial, cd_cx, cd_ctr),
		  CONSTRAINT pdv_cupom_nao_fiscal_est_rps_fkey FOREIGN KEY (cd_emp, cd_filial, cd_cx, cd_ctr)
		      REFERENCES public.pdv_cupom_nao_fiscal (cd_emp, cd_filial, cd_cx, cd_ctr) MATCH SIMPLE
		      ON UPDATE CASCADE ON DELETE CASCADE
		)
		WITH (
		  OIDS=FALSE
		);
		ALTER TABLE public.pdv_cupom_nao_fiscal_est_rps
		  OWNER TO postgres;
	ELSE    
		msgFinal := 'JÁ EXISTE';
	END IF;

	RAISE NOTICE 'Tabela pdv_cupom_nao_fiscal_est_rps %', msgFinal::varchar;

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION createTable() OWNER TO postgres;
SELECT createTable(); 
DROP FUNCTION createTable();
